<?php
// Test view-company.php functionality with correct company ID
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Test with company ID 2 (PetroSA)
    $company_id = 2;
    
    // Get company details
    $stmt = $db->prepare("SELECT * FROM companies WHERE id = ?");
    $stmt->execute([$company_id]);
    $company = $stmt->fetch();
    
    if ($company) {
        echo "Company found: {$company['name']}\n";
        echo "Contact: {$company['contact_person_name']} ({$company['contact_person_email']})\n\n";
    }
    
    // Test company users query
    $stmt = $db->prepare("
        SELECT * FROM company_users 
        WHERE company_id = ? 
        ORDER BY is_primary DESC, created_at ASC
    ");
    $stmt->execute([$company_id]);
    $company_users = $stmt->fetchAll();
    
    echo "Company users query successful!\n";
    echo "Found " . count($company_users) . " users:\n";
    
    foreach ($company_users as $user) {
        echo "- {$user['name']} ({$user['email']})";
        if ($user['is_primary']) echo " [PRIMARY]";
        echo " - Status: {$user['status']}\n";
    }
    
    // Test jobs query  
    $stmt = $db->prepare("
        SELECT j.*, jc.name as category_name, cu.name as posted_by
        FROM jobs j 
        LEFT JOIN job_categories jc ON j.category_id = jc.id
        LEFT JOIN company_users cu ON j.company_user_id = cu.id
        WHERE j.company_id = ? 
        ORDER BY j.created_at DESC 
        LIMIT 5
    ");
    $stmt->execute([$company_id]);
    $recent_jobs = $stmt->fetchAll();
    
    echo "\nJobs query successful!\n";
    echo "Found " . count($recent_jobs) . " jobs:\n";
    
    foreach ($recent_jobs as $job) {
        echo "- {$job['title']} (Posted by: {$job['posted_by']})\n";
        echo "  Status: {$job['status']}\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>