<?php
require_once '../config/config.php';
require_once '../includes/excel_generator.php';
requireLogin('company');

// Verify this is a POST request for security
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    redirect('applications.php');
}

$database = new Database();
$db = $database->getConnection();
$company_id = $_SESSION['company_id'];

// Get filters from form
$filters = [];

if (!empty($_POST['job_id'])) {
    $filters['job_id'] = (int)$_POST['job_id'];
}

if (!empty($_POST['status'])) {
    $filters['status'] = $_POST['status'];
}

if (!empty($_POST['date_from'])) {
    $filters['date_from'] = $_POST['date_from'];
}

if (!empty($_POST['date_to'])) {
    $filters['date_to'] = $_POST['date_to'];
}

try {
    // Export applications to Excel
    ExcelGenerator::exportApplications($db, $company_id, $filters);
} catch (Exception $e) {
    $_SESSION['error'] = 'Failed to export applications: ' . $e->getMessage();
    redirect('applications.php');
}
?>