<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

try {
    // Add nationality and identification fields to candidates table
    $alterSql = "
    ALTER TABLE candidates 
    ADD COLUMN nationality ENUM('south_african', 'foreign') DEFAULT 'south_african' AFTER gender,
    ADD COLUMN id_number VARCHAR(13) NULL AFTER nationality,
    ADD COLUMN passport_number VARCHAR(20) NULL AFTER id_number,
    ADD INDEX idx_nationality (nationality)
    ";
    
    $db->exec($alterSql);
    echo "Candidates table updated successfully!\n";
    echo "Added columns: nationality, id_number, passport_number\n";
    
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column name') !== false) {
        echo "Nationality columns already exist in candidates table.\n";
    } else {
        echo "Error updating candidates table: " . $e->getMessage() . "\n";
    }
}
?>