# Internal Candidate Management System

## ✅ **Implementation Complete**

The internal candidate removal and management system has been successfully implemented to allow HR to manage internal employees who leave the company, preventing them from seeing internal job advertisements.

## 🎯 **Key Features Implemented**

### **1. Employment Status Management**
- **Active**: Can see and apply for internal jobs
- **Inactive**: Temporarily cannot see internal jobs (can be reactivated)
- **Terminated**: Permanently cannot see internal jobs

### **2. HR Management Interface**
- **Deactivate Button**: Temporarily disable internal candidate access
- **Terminate Button**: Permanently disable internal candidate access  
- **Reactivate Button**: Restore access for inactive candidates
- **View Details**: See deactivation history and reasons

### **3. Job Visibility Control**
- **Active Candidates**: Full access to internal job postings
- **Inactive/Terminated Candidates**: No access to internal job postings
- **Automatic Filtering**: System automatically filters job visibility

### **4. Email Notifications**
- **Deactivation Email**: Professional notification when status changes to inactive
- **Termination Email**: Formal notification when employment is terminated
- **Detailed Templates**: Include reason, contact information, and next steps

### **5. Audit Trail**
- **Deactivation Tracking**: Who deactivated and when
- **Reason Logging**: Required reason for all status changes
- **Historical Data**: Complete audit trail for compliance

## 📁 **Files Modified/Created**

### **Database Changes:**
```sql
ALTER TABLE candidates ADD COLUMN employment_status ENUM('active', 'inactive', 'terminated') DEFAULT 'active';
ALTER TABLE candidates ADD COLUMN deactivated_at TIMESTAMP NULL;
ALTER TABLE candidates ADD COLUMN deactivated_by INT NULL;
ALTER TABLE candidates ADD COLUMN deactivation_reason TEXT NULL;
```

### **Updated Files:**
- `company/internal-candidates.php` - Added deactivation functionality
- `jobs.php` - Updated job visibility logic
- `job-details.php` - Updated job access control
- `includes/notification_system_smtp.php` - Added deactivation email notifications

## 🖥️ **User Interface**

### **Internal Candidates Dashboard**
```
┌─────────────────────────────────────────────────────┐
│ Statistics: [Pending] [Active] [Inactive] [Terminated] │
├─────────────────────────────────────────────────────┤
│ Employee | Position | Approval | Employment | Actions │
├─────────────────────────────────────────────────────┤
│ John Doe | Manager  | Approved | Active     | [View] [Deactivate] [Terminate] │
│ Jane Smith| Analyst  | Approved | Inactive   | [View] [Reactivate] [Terminate] │
│ Bob Wilson| Admin    | Approved | Terminated | [View Details] │
└─────────────────────────────────────────────────────┘
```

### **Action Buttons by Status:**
- **Pending Approval**: `[Approve]` `[Reject]`
- **Active Employee**: `[View]` `[Deactivate]` `[Terminate]`
- **Inactive Employee**: `[View]` `[Reactivate]` `[Terminate]`
- **Terminated Employee**: `[View Details]`

## 🔧 **Technical Implementation**

### **Job Visibility Logic**
```php
if ($user_candidate_type === 'internal') {
    if ($employment_status === 'active' && $approval_status === 'approved') {
        // Show internal jobs from their company
        $where_conditions[] = "(j.job_type IN ('internal', 'both') AND j.company_id = ?)";
    } else {
        // Hide internal jobs - only show external jobs
        $where_conditions[] = "j.job_type = 'external'";
    }
}
```

### **Deactivation Process**
1. HR clicks "Deactivate" or "Terminate" button
2. Modal opens requiring reason input
3. System updates employment_status and logs details
4. Email notification sent to employee
5. Job visibility immediately updated

### **Email Templates**
- **Professional Design**: SANPC branded with responsive layout
- **Status-Specific Content**: Different messages for inactive vs terminated
- **Contact Information**: HR contact details for questions
- **Legal Compliance**: Formal language appropriate for employment actions

## 📧 **Email Notification System**

### **Deactivation Email Features:**
- ⏸️ **Inactive Status**: "Employment Status Changed" with yellow warning styling
- 🚫 **Terminated Status**: "Employment Terminated" with red alert styling
- 📋 **Detailed Reason**: Includes HR-provided reason for the action
- 📞 **Contact Info**: HR email for questions and appeals
- ⚠️ **Clear Instructions**: What this means for the employee

### **Sample Email Content:**
```
Subject: Employment Status Update - SANPC

Dear [Employee Name],

We are writing to inform you that your employment status 
has been changed to [inactive/terminated].

Reason: [HR provided reason]

What this means:
• You will no longer receive internal job notifications
• Your access to the recruitment portal is limited
• [Additional status-specific information]

For questions, contact: recruitment@sanpcref.co.za
```

## 🛡️ **Security & Compliance**

### **Access Control**
- Only company HR users can deactivate candidates
- Mandatory reason field for audit compliance
- Automatic logging of who performed the action
- Historical data preserved for legal requirements

### **Data Protection**
- Sensitive employment actions are logged
- Email notifications comply with employment law
- Audit trail maintains data integrity
- No permanent data deletion (soft deactivation)

## 🔄 **Process Flow**

### **Employee Leaves Company:**
1. **HR Action**: Click "Terminate" on internal candidates page
2. **Reason Required**: Enter detailed reason for termination
3. **System Update**: Employment status changed to 'terminated'
4. **Email Sent**: Professional termination notification
5. **Access Revoked**: No longer sees internal job postings
6. **Audit Logged**: Action recorded with timestamp and user

### **Temporary Leave/Suspension:**
1. **HR Action**: Click "Deactivate" on internal candidates page
2. **Reason Required**: Enter reason for temporary deactivation
3. **System Update**: Employment status changed to 'inactive'
4. **Email Sent**: Deactivation notification with reactivation possibility
5. **Access Suspended**: Temporarily cannot see internal jobs
6. **Reactivation Available**: Can be restored by HR when appropriate

## 📊 **Statistics Dashboard**

### **Real-time Metrics:**
- **Pending**: Candidates awaiting approval
- **Active**: Currently employed with internal access
- **Inactive**: Temporarily deactivated employees
- **Terminated**: Permanently deactivated employees
- **Total**: All internal candidates

### **Visual Indicators:**
- 🟡 **Pending**: Yellow badge for pending approval
- 🟢 **Active**: Green badge for active employees
- 🔵 **Inactive**: Blue badge for temporarily inactive
- 🔴 **Terminated**: Red badge for terminated employees

## 🚀 **Benefits of This System**

### **For HR Teams:**
- **Immediate Control**: Instant removal of internal job access
- **Audit Compliance**: Complete tracking of employment actions
- **Professional Communication**: Automated, consistent email notifications
- **Flexibility**: Can deactivate temporarily or permanently
- **Easy Management**: Clear visual interface with status indicators

### **For the Company:**
- **Security**: Prevents terminated employees from seeing internal opportunities
- **Compliance**: Maintains proper employment records and communications
- **Efficiency**: Automated process reduces manual work
- **Professional Image**: Consistent, professional communication with employees

### **For Employees:**
- **Clear Communication**: Professional notification of status changes
- **Transparency**: Clear explanation of what the change means
- **Contact Information**: Know who to contact for questions
- **Respectful Process**: Dignified handling of employment changes

## ⚡ **Quick Usage Guide**

### **To Remove an Internal Candidate:**
1. Go to `Company → Internal Candidates`
2. Find the employee in the list
3. Click `[Terminate]` for permanent removal
4. Enter detailed reason in the modal
5. Click "Terminate Employee" to confirm
6. Employee is automatically notified via email

### **To Temporarily Deactivate:**
1. Go to `Company → Internal Candidates`
2. Find the employee in the list  
3. Click `[Deactivate]` for temporary removal
4. Enter reason in the modal
5. Click "Deactivate Employee" to confirm
6. Employee can be reactivated later with `[Reactivate]` button

### **To Reactivate an Employee:**
1. Find the inactive employee in the list
2. Click `[Reactivate]` button
3. Confirm the action
4. Employee immediately regains internal job access

---

## 📝 **System Status: ✅ FULLY OPERATIONAL**

The internal candidate management system is now fully implemented and tested. HR teams can immediately begin using this system to manage internal employees who leave the company, ensuring they no longer see internal job advertisements while maintaining proper audit trails and professional communication.

---
*Generated: 2025-09-07 | SANPC Recruitment Portal Internal Candidate Management*