<?php
// Test company user login functionality
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

// Get existing company user
$stmt = $db->query("SELECT cu.*, c.name as company_name FROM company_users cu INNER JOIN companies c ON cu.company_id = c.id LIMIT 1");
$company_user = $stmt->fetch();

if ($company_user) {
    echo "Found company user for testing:\n";
    echo "Name: {$company_user['name']}\n";
    echo "Email: {$company_user['email']}\n";
    echo "Company: {$company_user['company_name']}\n";
    echo "Is Primary: " . ($company_user['is_primary'] ? 'Yes' : 'No') . "\n";
    echo "Status: {$company_user['status']}\n\n";
    
    // Test the login query
    echo "Testing login query...\n";
    $stmt = $db->prepare("
        SELECT cu.*, c.name as company_name, c.status as company_status 
        FROM company_users cu 
        INNER JOIN companies c ON cu.company_id = c.id 
        WHERE cu.email = ? AND cu.status = 'active'
    ");
    $stmt->execute([$company_user['email']]);
    $login_user = $stmt->fetch();
    
    if ($login_user) {
        echo "Login query successful!\n";
        echo "Company Status: {$login_user['company_status']}\n";
        echo "User can login: " . ($login_user['company_status'] === 'approved' ? 'Yes' : 'No') . "\n";
    } else {
        echo "Login query failed - user not found or inactive.\n";
    }
} else {
    echo "No company users found. Please add a company through the admin interface first.\n";
}
?>