<?php
// Final test - check that filters with zero counts are hidden
$_GET = []; // Clear parameters
echo "Final test: Verifying only filters with data are shown...\n";

try {
    ob_start();
    include 'jobs.php';
    $output = ob_get_contents();
    ob_end_clean();
    
    // Check for any remaining zero counts
    $zero_count_matches = preg_match_all('/<span class="filter-count">\s*0\s*<\/span>/', $output);
    
    // Check for hardcoded fake counts (shouldn't be any)
    $fake_count_matches = preg_match_all('/rand\(|intval\(.*\*/', $output);
    
    // Count total filter options displayed
    $total_filter_options = preg_match_all('/<div class="filter-option"/', $output);
    
    // Check that major sections exist with conditional logic
    $conditional_tests = [
        'Date Posted conditional logic' => strpos($output, 'if ($new_jobs_count > 0)') !== false,
        'Work from home conditional logic' => strpos($output, 'if ($total_remote_count > 0)') !== false,
        'Functions conditional logic' => strpos($output, 'if ($categories_with_jobs > 0)') !== false,
        'Employment Type conditional logic' => strpos($output, 'if ($has_employment_types)') !== false,
        'No Application Method section' => strpos($output, '<h6>Application method</h6>') === false
    ];
    
    echo "Zero Count Filter Test Results:\n";
    echo "=================================\n";
    echo "❌ Filters showing zero counts: {$zero_count_matches}\n";
    echo "❌ Fake count patterns found: {$fake_count_matches}\n";
    echo "📊 Total filter options displayed: {$total_filter_options}\n";
    
    echo "\nConditional Logic Tests:\n";
    echo "========================\n";
    foreach ($conditional_tests as $test => $passed) {
        echo ($passed ? '✅' : '❌') . " {$test}\n";
    }
    
    if ($zero_count_matches == 0 && $fake_count_matches == 0) {
        echo "\n🎉 SUCCESS: All filters now show only real data!\n";
        echo "📍 Filters with zero counts are properly hidden\n";
        echo "📍 No more fake/hardcoded counts displayed\n";
        echo "📍 Only sections with actual jobs are shown\n";
    } else {
        echo "\n⚠️  Still some issues with zero counts or fake data.\n";
    }
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>