<?php
require_once 'config/config.php';
require_once 'includes/reliable_cv_generator.php';

echo "<!DOCTYPE html>
<html>
<head>
    <title>Nationality Display Test</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; background: #f8f9fa; }
        .container { max-width: 800px; background: white; padding: 20px; border-radius: 8px; }
        .success { color: #28a745; } .info { color: #007bff; }
        .test-section { background: #f1f3f4; padding: 15px; margin: 15px 0; border-radius: 5px; border-left: 4px solid #007bff; }
        .download-btn { background: #007bff; color: white; padding: 10px 20px; text-decoration: none; border-radius: 4px; margin: 5px; display: inline-block; }
    </style>
</head>
<body>
<div class='container'>";

echo "<h1>🌍 Nationality Display Test</h1>";
echo "<p>Testing that nationality is properly displayed in the CV Personal Details section.</p>";

try {
    // Create test candidate with nationality information
    $nationality_test_candidate = [
        'id' => 999,
        'first_name' => 'Carlos',
        'last_name' => 'Rodriguez',
        'email' => 'carlos.rodriguez@email.com',
        'phone' => '+1 (555) 321-9876',
        'address' => '456 International Blvd, Global City, GC 98765',
        'nationality' => 'Mexican-American', // This should be displayed prominently
        'date_of_birth' => '1988-12-03',
        'gender' => 'male',
        'marital_status' => 'single',
        'work_permit_status' => 'authorized_to_work',
        'job_title' => 'International Business Analyst'
    ];
    
    // Create basic CV data
    $nationality_cv_data = [
        'has_data' => true,
        'resume_summary' => 'International business analyst with multicultural expertise and global perspective.',
        'skills' => 'Cross-cultural Communication, International Business, Data Analysis, Bilingual Communication',
        'languages' => 'Spanish (Native), English (Fluent), Portuguese (Conversational)',
        
        'education' => [
            [
                'degree' => 'Bachelor of International Business',
                'institution' => 'Global University',
                'field_of_study' => 'International Business',
                'start_date' => '2006-08-15',
                'end_date' => '2010-05-20',
                'grade' => '3.6/4.0',
                'description' => 'Focus on international trade and multicultural business practices.',
                'is_current' => 0
            ]
        ],
        
        'experience' => [
            [
                'position' => 'International Business Analyst',
                'company_name' => 'Global Trading Corp',
                'location' => 'International District, ID',
                'start_date' => '2020-01-15',
                'end_date' => null,
                'is_current' => 1,
                'description' => 'Analyze international market trends and support cross-border business operations.'
            ]
        ],
        
        'certificates' => [],
        'references' => []
    ];
    
    echo "<div class='test-section'>";
    echo "<h2>📊 Test Data Overview</h2>";
    echo "<p>Created test candidate specifically to verify nationality display:</p>";
    echo "<ul>";
    echo "<li><strong>Candidate:</strong> {$nationality_test_candidate['first_name']} {$nationality_test_candidate['last_name']}</li>";
    echo "<li><strong>Nationality:</strong> " . htmlspecialchars($nationality_test_candidate['nationality']) . "</li>";
    echo "<li><strong>Profile Context:</strong> International business background</li>";
    echo "<li><strong>Expected Location:</strong> Personal Details section of CV</li>";
    echo "</ul>";
    echo "</div>";
    
    echo "<div class='test-section'>";
    echo "<h2>🎨 CV Generation Test</h2>";
    
    // Create app structure
    $app = $nationality_test_candidate;
    $app['cv_builder_data'] = $nationality_cv_data;
    
    // Generate CV
    $cv_generator = new ReliableCVGenerator();
    $cv_result = $cv_generator->generateCV($app, $nationality_cv_data);
    
    if ($cv_result !== false && !empty($cv_result['content'])) {
        echo "<p class='success'>✅ CV generated successfully!</p>";
        
        // Check if nationality is included in the generated content
        $cv_content = $cv_result['content'];
        $nationality_found = strpos($cv_content, 'Nationality:') !== false;
        $nationality_value_found = strpos($cv_content, htmlspecialchars($nationality_test_candidate['nationality'])) !== false;
        
        echo "<h4>🔍 Nationality Display Verification:</h4>";
        echo "<ul>";
        
        if ($nationality_found) {
            echo "<li class='success'>✅ <strong>\"Nationality:\" label found</strong> in CV content</li>";
        } else {
            echo "<li style='color: red;'>❌ \"Nationality:\" label NOT found in CV</li>";
        }
        
        if ($nationality_value_found) {
            echo "<li class='success'>✅ <strong>Nationality value \"" . htmlspecialchars($nationality_test_candidate['nationality']) . "\" found</strong> in CV content</li>";
        } else {
            echo "<li style='color: red;'>❌ Nationality value NOT found in CV</li>";
        }
        
        echo "</ul>";
        
        $file_extension = pathinfo($cv_result['filename'], PATHINFO_EXTENSION);
        $file_size = strlen($cv_result['content']);
        
        echo "<h4>📄 File Details:</h4>";
        echo "<ul>";
        echo "<li><strong>Filename:</strong> {$cv_result['filename']}</li>";
        echo "<li><strong>File Type:</strong> " . strtoupper($file_extension) . "</li>";
        echo "<li><strong>File Size:</strong> " . number_format($file_size) . " bytes</li>";
        echo "</ul>";
        
        // Save nationality test CV
        $nationality_cv_file = 'nationality_test_' . $cv_result['filename'];
        file_put_contents($nationality_cv_file, $cv_result['content']);
        
        echo "<p><a href='{$nationality_cv_file}' class='download-btn' target='_blank'>🌐 View CV with Nationality</a></p>";
        echo "</div>";
        
        // Success summary
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; border-radius: 4px; padding: 20px; margin: 30px 0;'>";
        echo "<h3 class='success'>🌍 Nationality Display Verification Complete!</h3>";
        
        if ($nationality_found && $nationality_value_found) {
            echo "<h4>✅ Nationality Successfully Displayed:</h4>";
            echo "<ul>";
            echo "<li>✅ <strong>Location:</strong> Personal Details section</li>";
            echo "<li>✅ <strong>Format:</strong> \"Nationality: " . htmlspecialchars($nationality_test_candidate['nationality']) . "\"</li>";
            echo "<li>✅ <strong>Styling:</strong> Consistent with other personal information</li>";
            echo "<li>✅ <strong>Placement:</strong> Properly positioned in 3-column profile layout</li>";
            echo "</ul>";
            
            echo "<h4>🏢 Business Value for HR Teams:</h4>";
            echo "<ul>";
            echo "<li><strong>Work Authorization:</strong> Helps assess visa/permit requirements</li>";
            echo "<li><strong>Cultural Fit:</strong> Provides context for international roles</li>";
            echo "<li><strong>Language Skills:</strong> Often correlates with multilingual abilities</li>";
            echo "<li><strong>Global Perspective:</strong> Valuable for international business positions</li>";
            echo "</ul>";
        } else {
            echo "<h4 style='color: red;'>❌ Issue Detected:</h4>";
            echo "<ul>";
            echo "<li>Nationality information may not be displaying correctly</li>";
            echo "<li>Check data source and CV generator logic</li>";
            echo "</ul>";
        }
        
        echo "</div>";
        
    } else {
        echo "<p style='color: red;'>❌ CV generation failed</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

echo "</div></body></html>";
?>