<?php
require_once 'config/config.php';

$database = new Database();
$db = $database->getConnection();

echo "<h2>🧪 Test Job Visibility Fix</h2>\n";

// Get sample data for testing
$stmt = $db->query("SELECT id, first_name, last_name, email, candidate_type, company_id FROM candidates WHERE candidate_type = 'internal' LIMIT 3");
$internal_candidates = $stmt->fetchAll();

$stmt = $db->query("SELECT id, title, job_visibility, company_id FROM jobs ORDER BY company_id, job_visibility LIMIT 10");
$jobs = $stmt->fetchAll();

echo "<h3>1. Current Jobs in Database</h3>\n";
echo "<table border='1' cellpadding='5'>\n";
echo "<tr><th>ID</th><th>Title</th><th>Visibility</th><th>Company ID</th></tr>\n";
foreach ($jobs as $job) {
    echo "<tr>";
    echo "<td>{$job['id']}</td>";
    echo "<td>" . substr($job['title'], 0, 40) . "...</td>";
    echo "<td>{$job['job_visibility']}</td>";
    echo "<td>{$job['company_id']}</td>";
    echo "</tr>\n";
}
echo "</table>\n";

echo "<h3>2. Internal Candidates</h3>\n";
echo "<table border='1' cellpadding='5'>\n";
echo "<tr><th>ID</th><th>Name</th><th>Email</th><th>Company ID</th></tr>\n";
foreach ($internal_candidates as $candidate) {
    echo "<tr>";
    echo "<td>{$candidate['id']}</td>";
    echo "<td>{$candidate['first_name']} {$candidate['last_name']}</td>";
    echo "<td>{$candidate['email']}</td>";
    echo "<td>{$candidate['company_id']}</td>";
    echo "</tr>\n";
}
echo "</table>\n";

// Test the filtering logic for each internal candidate
foreach ($internal_candidates as $candidate) {
    echo "<h3>3. Testing for {$candidate['first_name']} {$candidate['last_name']} (Company ID: {$candidate['company_id']})</h3>\n";
    
    // Simulate the new filtering logic from jobs.php
    $where_conditions = ["j.status = 'active'", "c.status = 'approved'"];
    $params = [];
    
    // Apply the NEW filtering logic
    $where_conditions[] = "(
        (j.job_visibility IN ('internal', 'both') AND j.company_id = ?) OR 
        (j.job_visibility IN ('external', 'both') AND j.company_id != ?)
    )";
    $params[] = $candidate['company_id'];
    $params[] = $candidate['company_id'];
    
    $where_clause = "WHERE " . implode(" AND ", $where_conditions);
    
    $stmt = $db->prepare("
        SELECT j.id, j.title, j.job_visibility, j.company_id, c.name as company_name
        FROM jobs j 
        LEFT JOIN companies c ON j.company_id = c.id 
        $where_clause 
        ORDER BY j.company_id, j.job_visibility
    ");
    $stmt->execute($params);
    $visible_jobs = $stmt->fetchAll();
    
    echo "<h4>Jobs {$candidate['first_name']} CAN see:</h4>\n";
    if ($visible_jobs) {
        echo "<table border='1' cellpadding='5'>\n";
        echo "<tr><th>ID</th><th>Title</th><th>Visibility</th><th>Company</th><th>Reason</th></tr>\n";
        foreach ($visible_jobs as $job) {
            $reason = '';
            if ($job['job_visibility'] == 'internal' && $job['company_id'] == $candidate['company_id']) {
                $reason = 'Internal job from own company';
            } elseif ($job['job_visibility'] == 'both' && $job['company_id'] == $candidate['company_id']) {
                $reason = 'Both visibility from own company';
            } elseif (in_array($job['job_visibility'], ['external', 'both']) && $job['company_id'] != $candidate['company_id']) {
                $reason = 'External/Both from other company';
            }
            
            echo "<tr>";
            echo "<td>{$job['id']}</td>";
            echo "<td>" . substr($job['title'], 0, 30) . "...</td>";
            echo "<td>{$job['job_visibility']}</td>";
            echo "<td>{$job['company_name']} (ID: {$job['company_id']})</td>";
            echo "<td style='font-size: 12px;'>$reason</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo "<p>No jobs visible</p>\n";
    }
    
    // Show jobs they CANNOT see (external-only from their own company)
    $stmt = $db->prepare("
        SELECT j.id, j.title, j.job_visibility, j.company_id, c.name as company_name
        FROM jobs j 
        LEFT JOIN companies c ON j.company_id = c.id 
        WHERE j.status = 'active' AND c.status = 'approved' 
        AND j.job_visibility = 'external' AND j.company_id = ?
        ORDER BY j.title
    ");
    $stmt->execute([$candidate['company_id']]);
    $hidden_jobs = $stmt->fetchAll();
    
    echo "<h4>Jobs {$candidate['first_name']} CANNOT see (blocked):</h4>\n";
    if ($hidden_jobs) {
        echo "<table border='1' cellpadding='5' style='background-color: #ffebee;'>\n";
        echo "<tr><th>ID</th><th>Title</th><th>Visibility</th><th>Company</th><th>Reason</th></tr>\n";
        foreach ($hidden_jobs as $job) {
            echo "<tr>";
            echo "<td>{$job['id']}</td>";
            echo "<td>" . substr($job['title'], 0, 30) . "...</td>";
            echo "<td>{$job['job_visibility']}</td>";
            echo "<td>{$job['company_name']} (ID: {$job['company_id']})</td>";
            echo "<td style='font-size: 12px; color: #d32f2f;'>❌ External-only from own company</td>";
            echo "</tr>\n";
        }
        echo "</table>\n";
    } else {
        echo "<p>✅ No external-only jobs from their company to hide</p>\n";
    }
    
    echo "<hr>\n";
}

// Summary
echo "<h3>4. Summary of Changes</h3>\n";
echo "<div style='background: #e8f5e8; color: #2e7d32; padding: 15px; border-radius: 5px; margin: 10px 0;'>\n";
echo "<h4>✅ Job Visibility Fix Applied:</h4>\n";
echo "<p><strong>Internal candidates can now see:</strong></p>\n";
echo "<ul>\n";
echo "<li>✅ Internal jobs from their company</li>\n";
echo "<li>✅ 'Both' visibility jobs from their company</li>\n";
echo "<li>✅ External and 'both' jobs from OTHER companies</li>\n";
echo "</ul>\n";
echo "<p><strong>Internal candidates CANNOT see:</strong></p>\n";
echo "<ul>\n";
echo "<li>❌ External-only jobs from their OWN company</li>\n";
echo "</ul>\n";
echo "<p><strong>Files Updated:</strong></p>\n";
echo "<ul>\n";
echo "<li>📄 jobs.php - Fixed job listing filtering</li>\n";
echo "<li>📄 job-details.php - Fixed job detail page access</li>\n";
echo "<li>📄 index.php - Already had correct logic</li>\n";
echo "</ul>\n";
echo "</div>\n";

?>

<style>
body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
table { width: 100%; margin: 20px 0; border-collapse: collapse; }
th, td { padding: 8px; text-align: left; border: 1px solid #ddd; }
th { background-color: #f2f2f2; }
h1, h2, h3, h4 { color: #333; }
</style>