<?php
require_once 'config/config.php';

echo "=== Checking Internal Candidate Approval System ===\n";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // Check candidates table structure
    $stmt = $db->prepare('DESCRIBE candidates');
    $stmt->execute();
    $columns = $stmt->fetchAll();
    
    echo "Candidates table columns related to approval:\n";
    foreach ($columns as $col) {
        if (stripos($col['Field'], 'approval') !== false || stripos($col['Field'], 'hr') !== false || stripos($col['Field'], 'status') !== false) {
            echo "- " . $col['Field'] . " (" . $col['Type'] . ")\n";
        }
    }
    
    // Check internal candidates and their approval status
    echo "\nInternal candidates and their approval status:\n";
    $stmt = $db->prepare("SELECT id, first_name, last_name, email, candidate_type, hr_approval_status FROM candidates WHERE candidate_type = 'internal'");
    $stmt->execute();
    $internalCandidates = $stmt->fetchAll();
    
    if (empty($internalCandidates)) {
        echo "No internal candidates found.\n";
    } else {
        foreach ($internalCandidates as $candidate) {
            echo "- ID: " . $candidate['id'] . ", Name: " . $candidate['first_name'] . " " . $candidate['last_name'] . ", Email: " . $candidate['email'] . ", Status: " . $candidate['hr_approval_status'] . "\n";
        }
    }
    
    // Look for approval-related files
    echo "\nLooking for approval-related files...\n";
    $approvalFiles = glob("*approval*");
    $internalFiles = glob("*internal*");
    
    echo "Files with 'approval' in name:\n";
    foreach ($approvalFiles as $file) {
        echo "- " . $file . "\n";
    }
    
    echo "Files with 'internal' in name:\n";
    foreach ($internalFiles as $file) {
        echo "- " . $file . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>