<?php
require_once 'config/config.php';

echo "<h1>🔧 Add Weight Column Migration</h1>\n";
echo "<p>This script will add the weight column to job_survey_questions table if it doesn't exist.</p>\n";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    echo "<p>✓ Database connection successful</p>\n";
    echo "<hr>\n";
    
    // Check if weight column exists
    echo "<h3>Checking weight column in job_survey_questions table</h3>\n";
    
    $stmt = $db->query("SHOW COLUMNS FROM job_survey_questions LIKE 'weight'");
    if (!$stmt->fetch()) {
        echo "<p>Adding weight column to job_survey_questions table...</p>\n";
        $db->exec("ALTER TABLE job_survey_questions ADD COLUMN weight DECIMAL(5,2) DEFAULT 100.00 AFTER is_required");
        echo "<div style='color: green;'>✓ Added weight column (DECIMAL type for percentage values)</div>\n";
    } else {
        echo "<div style='color: orange;'>⚠ weight column already exists</div>\n";
    }
    
    // Verify the column was added
    echo "<h3>Verification</h3>\n";
    $stmt = $db->query("SHOW COLUMNS FROM job_survey_questions");
    $columns = $stmt->fetchAll();
    
    echo "<p><strong>Current job_survey_questions table structure:</strong></p>\n";
    echo "<ul>\n";
    foreach ($columns as $column) {
        $highlight = ($column['Field'] === 'weight') ? 'style="background-color: yellow;"' : '';
        echo "<li {$highlight}><strong>{$column['Field']}</strong> ({$column['Type']}) - Default: {$column['Default']}</li>\n";
    }
    echo "</ul>\n";
    
    // Update existing questions without weights to have default weight
    echo "<h3>Updating existing questions</h3>\n";
    $stmt = $db->query("SELECT COUNT(*) as count FROM job_survey_questions WHERE weight IS NULL OR weight = 0");
    $result = $stmt->fetch();
    
    if ($result['count'] > 0) {
        echo "<p>Found {$result['count']} questions without weights. Setting default weight to 100%...</p>\n";
        $db->exec("UPDATE job_survey_questions SET weight = 100.00 WHERE weight IS NULL OR weight = 0");
        echo "<div style='color: green;'>✓ Updated {$result['count']} questions with default weight</div>\n";
    } else {
        echo "<p>All questions already have weight values.</p>\n";
    }
    
    echo "<div style='color: green; padding: 20px; background: #d4edda; border: 1px solid #c3e6cb; margin: 20px 0; border-radius: 5px;'>\n";
    echo "<h2>✅ Weight Column Migration Complete!</h2>\n";
    echo "<p>The weight column has been successfully added to the job_survey_questions table.</p>\n";
    echo "<p><strong>Next Steps:</strong></p>\n";
    echo "<ul>\n";
    echo "<li>Try editing a job with survey questions</li>\n";
    echo "<li>The edit form should now load existing questions with their weights</li>\n";
    echo "<li>New questions will require weight percentages that total 100%</li>\n";
    echo "</ul>\n";
    echo "</div>\n";
    
} catch (Exception $e) {
    echo "<div style='color: red; padding: 15px; background: #f8d7da; border: 1px solid #f5c6cb; margin: 20px 0; border-radius: 5px;'>\n";
    echo "<h4>💥 Migration Error!</h4>\n";
    echo "<p><strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "</p>\n";
    echo "<p><strong>File:</strong> " . htmlspecialchars($e->getFile()) . "</p>\n";
    echo "<p><strong>Line:</strong> " . $e->getLine() . "</p>\n";
    echo "</div>\n";
}
?>

<style>
body { 
    font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; 
    margin: 30px; 
    line-height: 1.6;
    color: #333;
    background-color: #f8f9fa;
}
h1 { color: #2c3e50; margin-bottom: 10px; text-align: center; }
h2 { color: #34495e; margin-top: 30px; }
h3 { color: #7f8c8d; margin-top: 25px; margin-bottom: 15px; border-bottom: 2px solid #ecf0f1; padding-bottom: 5px; }
h4 { color: #5d6d7e; margin-top: 20px; }
p { margin: 12px 0; }
hr { margin: 25px 0; border: none; border-top: 2px solid #ecf0f1; }
ul, ol { padding-left: 25px; }
li { margin: 8px 0; }
</style>