-- Add job visibility field to jobs table
-- This allows companies to specify if jobs are for external, internal, or both types of candidates

ALTER TABLE jobs 
ADD COLUMN job_visibility ENUM('external', 'internal', 'both') DEFAULT 'external' AFTER experience_level;

-- Add index for better performance when filtering jobs
ALTER TABLE jobs 
ADD INDEX idx_job_visibility (job_visibility);

-- Update existing jobs to default to 'external' (they were implicitly external before)
UPDATE jobs 
SET job_visibility = 'external' 
WHERE job_visibility IS NULL;

COMMIT;