# Email App Installation Instructions

This simple PHP email application uses PHPMailer to send emails through your cPanel email account.

## Requirements
- PHP 7.4 or higher
- Composer (for PHPMailer installation)
- Access to your cPanel email settings

## Installation Steps

### 1. Install PHPMailer via Composer

Open terminal/command prompt in the project directory and run:

```bash
composer install
```

If Composer is not installed, download it from https://getcomposer.org/

### 2. Manual PHPMailer Installation (Alternative)

If you can't use Composer, download PHPMailer manually:

1. Download PHPMailer from: https://github.com/PHPMailer/PHPMailer/releases
2. Extract to a `vendor/phpmailer/phpmailer/src/` folder in your project
3. Update the include paths in `send_email.php`

### 3. Configure Email Settings

The email configuration is already set up in `config/email_config.php` with your provided credentials:

- Host: mail.sanpcref.co.za
- Username: recruitment@sanpcref.co.za
- Password: P@$$word@2025
- Port: 587 (TLS)

### 4. Upload to cPanel

1. Upload all files to your cPanel's public_html directory (or subdirectory)
2. Ensure proper file permissions (644 for files, 755 for directories)
3. Make sure PHP is enabled on your hosting

### 5. Test the Application

1. Navigate to your domain/index.html
2. Fill out the email form
3. Click "Send Email"

## File Structure

```
email2/
├── config/
│   └── email_config.php    # Email configuration
├── vendor/                 # Composer dependencies (created after composer install)
├── composer.json          # Composer configuration
├── index.html             # Email form
├── send_email.php         # Email sending script
└── INSTALLATION.md        # This file
```

## Troubleshooting

### Common Issues:

1. **"PHPMailer not found" error**: Install PHPMailer via Composer or manually
2. **SMTP connection issues**: Verify your cPanel email settings and firewall
3. **Authentication failed**: Double-check email credentials in config file
4. **Port issues**: Try port 465 with SSL if 587 with TLS doesn't work

### cPanel SMTP Settings:

- **Incoming Server**: mail.sanpcref.co.za
- **Outgoing Server**: mail.sanpcref.co.za
- **Port 587** (TLS) or **Port 465** (SSL)
- **Authentication**: Required

## Security Notes

- The password is stored in plain text in the config file
- Consider using environment variables for production
- Implement rate limiting to prevent spam
- Add CSRF protection for production use

## Usage

1. Open the application in your browser
2. Enter recipient email address
3. Enter subject line
4. Type your message
5. Click "Send Email"

The application will display a success or error message after attempting to send the email.